import logging
from typing import List
from scoring import Result, Checkpoint
from common import grader, check_file_in_owncloud_directory

@grader
def grade_checkpoint1():
    file_name = "duplicate_invoices_report.xlsx"
    dir_name = "Documents/Financials"

    exists = check_file_in_owncloud_directory(file_name, dir_name)
    if exists:
        logging.info("✅ duplicate_invoices_report.xlsx was created and uploaded.")
        return 0
    else:
        logging.info("❌ duplicate_invoices_report.xlsx was not found in OwnCloud.")
        return 1

def grade_checkpoints(trajectory="") -> Result:
    checkpoints: List[Checkpoint] = [Checkpoint(1, int(grade_checkpoint1()))]
    return Result(checkpoints)
